package org.example;

import com.google.common.primitives.Ints;
import org.apache.commons.lang3.ArrayUtils;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;

public class Main {


    public static <T> Iterable<T> convertArrayToIterable(T[] array) {
        List<T> list = Arrays.stream(array).toList();
        return new Iterable<T>() {
            @Override
            public Iterator<T> iterator() {
                return list.iterator();
            }
        };
    }

    public static <T> Iterable<T> convertArrayToIterableB(T[] array) {
        Stream<T> stream = Arrays.stream(array);
        Iterator<T> iterator = stream.iterator();
        return new Iterable<T>() {
            @Override
            public Iterator<T> iterator() {
                return iterator;
            }
        };
    }

    public static <T> Iterable<T> convertArrayToIterableC(T[] array) {
        T[] boxedArray = ArrayUtils.toArray(array);
        return Arrays.asList(boxedArray);
    }

    public static Iterable<Integer> convertArrayToIterableD(int[] array) {
        List<Integer> list = Ints.asList(array);
        return list;
    }

    public static void main(String[] args) {
        String[] fruits = {"Apple", "Banana", "Orange"};
        Iterable<String> iterable = convertArrayToIterable(fruits);
        for (String fruit : iterable) {
            System.out.println(fruit);
        }
        Integer[] numbers = {1, 2, 3, 4, 5};
        Iterable<Integer> iterableB = convertArrayToIterableB(numbers);
        for (Integer number : iterableB) {
            System.out.println(number);
        }
        Double[] prices = {10.99, 19.99, 5.99};
        Iterable<Double> iterableC = convertArrayToIterableC(prices);
        for (Double price : iterableC) {
            System.out.println(price);
        }
        int[] temperatures = {25, 28, 30, 26, 27};
        Iterable<Integer> iterableD = convertArrayToIterableD(temperatures);
        for (Integer temperature : iterableD) {
            System.out.println(temperature);
        }
    }
}